/*
#
# Header for GOP class
#
# $Id: GroupOfPictures.h,v 1.6 2003/04/27 07:21:56 nemies Exp $
#
# Copyright (C) 2001-2003 Kees Cook
# kees@outflux.net, http://outflux.net/
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# http://www.gnu.org/copyleft/gpl.html
#
*/

#ifndef _GROUPOFPICTURES_H_
#define _GROUPOFPICTURES_H_

#include "config.h"
#include "Vector.h"
#include "Bounds.h"

class GroupOfPictures:public Vector
{
  public:
    GroupOfPictures(Vector * head);
    ~GroupOfPictures();

    // lists
    Bounds *getPacketBounds();
    Bounds *getPictureBounds();

    Vector *getHeader();

    // information
    char *strTimeCode();
  private:
    // GOP header itself
    Vector * header;

    Bounds *packets;            // high-level pack's
    Bounds *pictures;           // picture groups

    void updateTimeCode();
    uint32_t hours, mins, secs, pics;
};

#endif // _GROUPOFPICTURES_H_

/* vi:set ai ts=4 sw=4 expandtab: */
