/* vi:set ai ts=4 sw=4 expandtab: */
/*
#
# C++-ized callbacks.c file produced by Glade for GTK event callbacks
#
# $Id: callbacks.cpp,v 1.12 2003/04/27 03:08:37 nemies Exp $
#
# Copyright (C) 2001-2003 Kees Cook
# kees@outflux.net, http://outflux.net/
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# http://www.gnu.org/copyleft/gpl.html
#
*/

#include "GOPchop.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <stdio.h>

extern "C"
{
#include "callbacks.h"
#include "interface.h"
#include "support.h"
}

#include "main.h"
#include "gettext.h"

#include "Picture.h"


void file_is_loaded()
{
    List *GOPs;
    List *pictures;
    GtkAdjustment *scale;
    gchar buf[128];
    char *pathname;
    int picture_count = 0;

    // toggle our file options
    gtk_widget_set_sensitive(menu_open, FALSE);
    gtk_widget_set_sensitive(menu_close, TRUE);
    gtk_widget_set_sensitive(menu_save, TRUE);
    gtk_widget_set_sensitive(button_run, TRUE);
    gtk_widget_set_sensitive(button_prev, TRUE);
    gtk_widget_set_sensitive(button_next, TRUE);
    gtk_widget_set_sensitive(button_refresh, TRUE);
    gtk_widget_set_sensitive(button_start_mark, TRUE);
    gtk_widget_set_sensitive(button_end_mark, FALSE);

    // adjust the slider scales
    scale = gtk_range_get_adjustment(GTK_RANGE(GOP_selector));
    scale->upper = mpeg2parser->numGOPs();
    gtk_adjustment_changed(GTK_ADJUSTMENT(scale));

    // start decode window
    decode_start();
    set_GOP_selected(0);

    pathname = mpeg2parser->getFilename();
    if (!pathname)
        pathname = "unknown";
    gtk_label_set_text(GTK_LABEL(GOP_label_filename), pathname);
}

void file_is_unloaded()
{
    GtkAdjustment *scale;

    // stop decode window
    decode_stop();
    set_GOP_selected(0);

    // toggle our file options
    gtk_widget_set_sensitive(menu_open, TRUE);
    gtk_widget_set_sensitive(menu_close, FALSE);
    gtk_widget_set_sensitive(menu_save, FALSE);
    gtk_widget_set_sensitive(button_run, FALSE);
    gtk_widget_set_sensitive(button_prev, FALSE);
    gtk_widget_set_sensitive(button_next, FALSE);
    gtk_widget_set_sensitive(button_refresh, FALSE);
    gtk_widget_set_sensitive(button_start_mark, FALSE);
    gtk_widget_set_sensitive(button_end_mark, FALSE);

    // adjust the slider scales
    scale = gtk_range_get_adjustment(GTK_RANGE(GOP_selector));
    scale->upper = 0.0;
    gtk_adjustment_changed(GTK_ADJUSTMENT(scale));

    // wipe out GOP info window
    gtk_clist_clear(GTK_CLIST(GOP_clist));
    gtk_label_set_text(GTK_LABEL(GOP_label_filename), "");

    // wipe out clip window
    gtk_clist_clear(GTK_CLIST(main_clist));
    main_clist_row = -1;

    // reset parser
    mpeg2parser->reset();

    if (error_dialog)
    {
        // hide the errors (no errors now!)
        gtk_widget_hide(error_dialog);
    }
}


void on_menu_file_open_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    if (!fileselection_window)
    {
        fileselection_window = create_fileselection_window();
    }
    gtk_widget_show(fileselection_window);
}


void on_menu_file_save_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    if (!saveselection_window)
    {
        saveselection_window = create_saveselection_window();
    }
    gtk_widget_show(saveselection_window);
}


void on_menu_file_close_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    file_is_unloaded();
}


void on_menu_file_exit_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    mpeg2parser->reset();
    gtk_main_quit();
}


void on_menu_help_about_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    static char buf[1024];
    GtkWidget *label;

    if (!about_window)
    {
        about_window = create_about_window();

        // set version in window
        snprintf(buf, 1023, _("GOPchop Version %s"), GOPchop_version);
        label = GTK_WIDGET(lookup_widget(GTK_WIDGET(about_window),
                                         "about_label_version"));
        gtk_label_set_text(GTK_LABEL(label), buf);

        label = GTK_WIDGET(lookup_widget(GTK_WIDGET(about_window),
                                         "about_label_cvsid"));
        gtk_label_set_text(GTK_LABEL(label), GOPchop_cvsid);
    }

    gtk_widget_show(about_window);
}


void on_button_run_toggled(GtkToggleButton * togglebutton, gpointer user_data)
{
    int GOPs, i;

    GOPs = mpeg2parser->numGOPs();
    i = get_GOP_selected();

    while (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton)))
    {
        set_GOP_selected(i);
        flush();
        i = get_GOP_selected();
        i++;
        if (i == GOPs)
        {
            if (options.run_loop)
                i = 0;
            else
            {
                // flip back off now
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(togglebutton),
                                             FALSE);
                flush();
            }
        }
    }
}


void on_about_window_destroy(GtkObject * object, gpointer user_data)
{
    about_window = NULL;
}


void on_about_button_cool_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_hide(about_window);
    gtk_widget_destroy(about_window);
}


void
on_fileselection_button_ok_clicked(GtkButton * button, gpointer user_data)
{
    gchar *filename;

    gtk_widget_hide(fileselection_window);
    flush();

    filename =
        gtk_file_selection_get_filename(GTK_FILE_SELECTION
                                        (fileselection_window));

    open_file(filename);
}


void
on_fileselection_button_cancel_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_hide(fileselection_window);
// we should leave this off so that we will always be back where we left off
//        gtk_widget_destroy(fileselection_window);
}


void on_fileselection_window_destroy(GtkObject * object, gpointer user_data)
{
    fileselection_window = NULL;
}


void on_error_button_annoying_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_hide(error_dialog);
}

static int mark_start;
static int mark_end;

void on_button_start_mark_clicked(GtkButton * button, gpointer user_data)
{
    char buf[128];

    mark_start = get_GOP_selected();
    gtk_widget_set_sensitive(button_end_mark, TRUE);
    gtk_widget_set_sensitive(button_start_mark, FALSE);

    sprintf(buf, "%d", mark_start);
    gtk_label_set_text(GTK_LABEL(main_label_mark), buf);
}


void on_button_end_mark_clicked(GtkButton * button, gpointer user_data)
{
    mark_end = get_GOP_selected();

    if (mark_end >= mark_start)
    {
        gtk_widget_set_sensitive(button_end_mark, FALSE);
        gtk_widget_set_sensitive(button_start_mark, TRUE);

        gtk_label_set_text(GTK_LABEL(main_label_mark), "no mark set");

        add_GOP_slice(mark_start, mark_end);
    }
    else
    {
        // FIXME: do something to flash the startmark label
    }
}


void on_button_refresh_clicked(GtkButton * button, gpointer user_data)
{
    show_GOP(get_GOP_selected());
}


void
on_menu_options_run_loop_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    options.run_loop=GTK_CHECK_MENU_ITEM(menuitem)->active;
    rc_save(PACKAGE,parsable_items);
}


void
on_menu_options_auto_refresh_activate(GtkMenuItem * menuitem,
                                      gpointer user_data)
{
    options.auto_refresh=GTK_CHECK_MENU_ITEM(menuitem)->active;
    rc_save(PACKAGE,parsable_items);
}


gboolean
on_main_clist_key_press_event(GtkWidget * widget,
                              GdkEventKey * event, gpointer user_data)
{
    if (main_clist_row > -1)
    {
        switch (event->keyval)
        {
            case GDK_Delete:
            case GDK_KP_Delete:
            case GDK_BackSpace:
                gtk_clist_remove(GTK_CLIST(main_clist), main_clist_row);
                main_clist_row = -1;
                return TRUE;
                break;
        }
    }
    return FALSE;
}


gboolean
on_main_clist_button_press_event(GtkWidget * widget,
                                 GdkEventButton * event, gpointer user_data)
{

#if 0
    if (event->button == 3)     // right-click
    {
        main_popup_info.x = event->x;
        main_popup_info.y = event->y;
        gtk_menu_popup(GTK_MENU(main_popup), NULL, NULL, NULL,
                       &main_popup_info, event->button, event->time);
        return TRUE;
    }
#endif

    return FALSE;
}


void on_main_popup_delete_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gint row, col;
    popup_info_t *info;

    if (info = (popup_info_t *) user_data)
    {
        gtk_clist_get_selection_info(GTK_CLIST(main_clist),
                                     info->x, info->y, &row, &col);

        //printf("bloa! (x %d y %d is row %d col %d)\n");
    }
    else
        printf("%s",
               _("Oops.  NULL info in on_main_popup_delete_activate\n"));

}


void
on_main_clist_select_row(GtkCList * clist,
                         gint row,
                         gint column, GdkEvent * event, gpointer user_data)
{
    main_clist_row = row;
}


void
on_main_clist_unselect_row(GtkCList * clist,
                           gint row,
                           gint column, GdkEvent * event, gpointer user_data)
{
    main_clist_row = -1;
}


void on_menu_file_clear_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    gtk_clist_clear(GTK_CLIST(main_clist));
}


void on_saveselection_window_destroy(GtkObject * object, gpointer user_data)
{
    saveselection_window = NULL;
}


void
on_saveselection_button_ok_clicked(GtkButton * button, gpointer user_data)
{
    gchar *filename;

    gtk_widget_hide(saveselection_window);
    flush();

    filename =
        gtk_file_selection_get_filename(GTK_FILE_SELECTION
                                        (saveselection_window));

    if (!access(filename, F_OK))
    {
        if (!overwrite_dialog)
            overwrite_dialog = create_overwrite_dialog();
        gtk_label_set_text(GTK_LABEL(overwrite_label_filename), filename);
        gtk_widget_show(overwrite_dialog);
    }
    else
        save_file(filename);
}

void
on_saveselection_button_cancel_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_hide(saveselection_window);
}

void on_overwrite_button_ok_clicked(GtkButton * button, gpointer user_data)
{
    gchar *filename;

    gtk_widget_hide(overwrite_dialog);
    flush();
    gtk_label_get(GTK_LABEL(overwrite_label_filename), &filename);
    save_file(filename);
}


void
on_overwrite_button_cancel_clicked(GtkButton * button, gpointer user_data)
{
    gtk_widget_hide(overwrite_dialog);
}



void on_button_next_clicked(GtkButton * button, gpointer user_data)
{
    set_GOP_selected(get_GOP_selected() + 1);
}


void on_button_prev_clicked(GtkButton * button, gpointer user_data)
{
    set_GOP_selected(get_GOP_selected() - 1);
}


void
on_menu_options_preferences_activate(GtkMenuItem * menuitem,
                                     gpointer user_data)
{

}


void
on_menu_options_ignore_errors_activate(GtkMenuItem * menuitem,
                                       gpointer user_data)
{
    options.ignore_errors=GTK_CHECK_MENU_ITEM(menuitem)->active;
    rc_save(PACKAGE,parsable_items);
}


void
on_menu_options_drop_orphaned_frames_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    options.drop_orphaned_frames=GTK_CHECK_MENU_ITEM(menuitem)->active;
    rc_save(PACKAGE,parsable_items);
}

