/*
#
# This is to handle GTK initialization and utility
#
# $Id: main.h,v 1.8 2003/04/27 04:13:19 nemies Exp $
#
# Copyright (C) 2001-2003 Kees Cook
# kees@outflux.net, http://outflux.net/
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# http://www.gnu.org/copyleft/gpl.html
#
*/

#ifndef _MAIN_H_
#define _MAIN_H_

#include "config.h"

#include <gtk/gtk.h>
#include <glib.h>

#include "MPEG2Parser.h"
#include "rc.h"

#ifdef __cplusplus
extern "C" {
#endif



typedef struct
{
    gint x;
    gint y;
}
popup_info_t;

// version
extern char *GOPchop_cvsid;
extern char *GOPchop_version;

// windows
extern GtkWidget *main_window;
extern GtkWidget *about_window;
extern GtkWidget *fileselection_window;
extern GtkWidget *saveselection_window;
extern GtkWidget *error_dialog;
extern GtkWidget *overwrite_dialog;
extern GtkWidget *GOP_window;

// menus and buttons
extern GtkWidget *menu_open;
extern GtkWidget *menu_save;
extern GtkWidget *menu_close;
extern GtkWidget *button_run;
extern GtkWidget *button_refresh;
extern GtkWidget *button_prev;
extern GtkWidget *button_next;
extern GtkWidget *button_start_mark;
extern GtkWidget *button_end_mark;
extern GtkWidget *menu_options_run_loop;
extern GtkWidget *menu_options_auto_refresh;
extern GtkWidget *main_popup;
extern popup_info_t main_popup_info;

// things
extern GtkWidget *main_progressbar;
extern GtkWidget *main_statusbar;
extern GtkWidget *main_clist;
extern GtkWidget *main_label_mark;
extern GtkWidget *GOP_selector;
extern GtkWidget *GOP_clist;
extern GtkWidget *GOP_label_filename;
extern GtkWidget *overwrite_label_filename;
extern gint main_clist_row;

// objects
extern MPEG2Parser *mpeg2parser;

// global status info
extern const gchar *fileops;

/* global option control */
typedef struct
{
    int run_loop;             /* when in "Run" mode, wrap to beginning at end */
    int auto_refresh;         /* redraw the frames after moving the slider */
    int ignore_errors;        /* don't store errors about file loading */
    int drop_orphaned_frames; /* get rid of starting B frames on an open GOP */
} global_options;
extern global_options options;
extern rc_parse_item parsable_items[];

// supporting functions
void progress(char *task, float done);
void status_on(const gchar * owner, char *text);
void status_off(const gchar * owner);
void show_error(char *text);
void flush();
uint32_t get_GOP_selected();
void set_GOP_selected(uint32_t num);
const char *frame_type_str(int type);
void update_GOP_info(uint32_t num);
void open_file(char *filename);
void save_file(char *filename);
void add_GOP_slice(uint32_t start, uint32_t end);

// from callback.cpp (FIXME: move functions over)
void file_is_loaded();

// decode functions
void decode_start();
void decode_stop();
void show_GOP(uint32_t wantedGOP);


#ifdef __cplusplus
}
#endif

#endif /* _MAIN_H_ */

/* vi:set ai ts=4 sw=4 expandtab: */
