/*
 * header file for firmware updating code
 *
 * Copyright (C) 2001 Kees Cook
 * cook@cpoint.net, http://outflux.net/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 */
#ifndef FIRMWARE_H
#define FIRMWARE_H

/* product ID name length */
#define NAMLEN	16

typedef struct unit_id {
	char name[NAMLEN + 1];
	char fw_ver[7];
} unit_id;

/* how much can we push to the STS per WRITE BUFFER? */
#define MAX_PUSH	128

#define OKAY		 1
#define FAILED		 0
#define BADSTATE	-1

typedef struct firmware_img {
	int fd;
	u_char * image;
	size_t length;
	unit_id unit;
} firmware_img;

/* firmware image handlers */
char * build_firmware_filename(char * product_id);
firmware_img * load_firmware(char * filename);
unit_id *verify_image(firmware_img * firmware);
void unload_firmware(firmware_img * firmware);

/* firmware uploader */
int upload_now(scsi_info *dev, firmware_img *firmware);

#endif /* FIRMWARE_H */
