/*
 * This program uses the scsi_tools.o to scan the SCSI bus
 *
 * $Id: scanbus.c,v 1.14 2001/02/16 01:56:37 root Exp $
 *
 * Copyright (C) 2001 Kees Cook
 * cook@cpoint.net, http://outflux.net/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 */
#include <stdio.h>
#include <sys/types.h>
#include "scsi_tools.h"

int main (int argc, char * argv[]) {
  int i;
  char sgfile[64];
  scsi_info * dev;

  printf(" Status H/C/Id.LUN Vendor     Product            Ver    Type          /dev\n");
  printf("------- ---------- ---------- ------------------ ------ ------------- ----\n");
  for (i=0;i<128;i++) {
	sprintf(sgfile,"/dev/sg%d",i);

        if ((dev = scsi_open_name(sgfile))!=NULL) {

		printf("%7s %d/%d/%02d.%d   '%s' '%s' '%s' %-13s sg%d\n",
			scsi_unitready(dev) ? "online" : "OFFLINE",
			dev->sginfo.host_no,
			dev->sginfo.channel,
			dev->sginfo.scsi_id,
			dev->sginfo.lun,
			dev->vendor, dev->product, dev->version,
			scsi_type(dev->sginfo.scsi_type),i
		);

		scsi_close(dev);
	}
  }

  return 0;
}
