/*
 * header file for the SCSI low-level interface
 *
 * Copyright (C) 2001 Kees Cook
 * cook@cpoint.net, http://outflux.net/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 */
#ifndef SCSI_IFACE_H
#define SCSI_IFACE_H

/* for typing convenience */
#define SG_LEN          sizeof(struct sg_header)
#define MAX_PACKET      4096 /* could be SG_BIG_BUFF too... */

int start_scsi_cmd(
                        int fd,                 /* sg fd */
                        unsigned cmd_len,       /* command length */
                        unsigned in_size,       /* input data size */
                        unsigned char *i_buff,  /* input buffer */
                        unsigned out_size       /* output data size */
                   );

int finish_scsi_cmd(
                        int fd,                 /* sg fd */
                        unsigned out_size,      /* output data size */
                        unsigned char *o_buff   /* output buffer */
                    );

int waitfor_scsi_cmd(
                        int fd,                 /* sg fd */
                        unsigned cmd_len,       /* command length */
                        unsigned in_size,       /* input data size */
                        unsigned char *i_buff,  /* input buffer */
                        unsigned out_size,      /* output data size */
                        unsigned char *o_buff   /* output buffer */
                      );

#endif /* SCSI_IFACE_H */
