/*
 * header file for the scsi_tools.c library
 *
 * Copyright (C) 2001 Kees Cook
 * cook@cpoint.net, http://outflux.net/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 */
#ifndef SCSI_TOOLS_H
#define SCSI_TOOLS_H
#include <scsi/sg.h>
#include <scsi/scsi.h>

#ifndef TYPE_COMM
# define TYPE_COMM 0x09
#endif

/* FIXME: get some of this stuff from <scsi/scsi.h> */
#define INQUIRY_CMD     0x12
#define INQUIRY_CMDLEN  6
#define INQUIRY_REPLY_LEN 96
#define VENDOR_INFO_LEN 28
#define VENDOR_START  8 /* Offset in reply data to vendor name */

#define TESTUNITREADY_CMD 0
#define TESTUNITREADY_CMDLEN 6

#define ADD_SENSECODE 12
#define ADD_SC_QUALIFIER 13
#define NO_MEDIA_SC 0x3a
#define NO_MEDIA_SCQ 0x00

typedef struct scsi_info {
	int fd;	
	char * filename;
	char * fullinq; /* full inquiry buffer */
	Sg_scsi_id sginfo;
	char vendor[9];
	char product[17];
	char version[5];
} scsi_info;

scsi_info * scsi_inquiry (scsi_info * dev);
int scsi_unitready (scsi_info * dev);
scsi_info * scsi_open_name(char * filename);
scsi_info * scsi_open_id(int host, int chan, int id, int lun);
void scsi_close(scsi_info * dev);
char * scsi_type(int type);

#endif /* SCSI_TOOLS_H */
