#include "CoordHash.h"

CoordHash::CoordHash(int xmax, int ymax, int step) {
	int i,j;

	my_step = step;
	my_xmax = xmax;
	my_ymax = ymax;	
	x_off = (xmax / step) + 1;
	y_off = (ymax / step) + 1;
	hash = new Queue<Vertex> *[x_off*y_off];
	for (i=0;i<x_off;i++) {
		for (j=0;j<y_off;j++) {
			hash[(i*y_off) + j] = new Queue<Vertex>(FALSE);
		}
	}
}

CoordHash::~CoordHash(void) {
	int i,j;
	for (i=0;i<x_off;i++) {
		for (j=0;j<y_off;j++) {
			delete hash[(i*y_off) + j];
		}
	}
	delete []hash;
}

void CoordHash::add(Vertex * vertex) {
	hash[((vertex->x() / my_step) * y_off) + (vertex->y()/my_step)]->add(vertex);
}

int CoordHash::offset(int what) {
	return what / my_step;
}

Queue<Vertex> * CoordHash::chunk(int x, int y) {
//	fprintf(stderr,"(%d,%d)\n",x,y);
	return hash[(x * y_off) + y];
}

Queue<Vertex> * CoordHash::at(int x, int y) {
	return hash[((x / my_step) * y_off) + (y / my_step)];
}

void CoordHash::getlimits(int * xa, int * ya, int * xb, int * yb) {
//	fprintf(stderr,"(0,0) - (%d,%d)\n",x_off,y_off);
	*xa = 0;
	*ya = 0;

	*xb = x_off;
	*yb = y_off;
}
