#include <math.h>
#include "Edge.h"

Edge::Edge(Vertex * one, Vertex * two, int color=BLACK) {
	int xdiff,ydiff;

	my_color = color;
	vertex_one = one;
	vertex_two = two;

//	fprintf(stderr,"      new edge from (%d,%d),(%d,%d)\n",one->x(),one->y(),two->x(),two->y());

	xdiff = (one->x() - two->x());
//	fprintf(stderr,"      xdiff = %d\n",xdiff);
	if (xdiff == 0) {
		my_slope = 10e10;
	}
	else {
		ydiff = (one->y() - two->y());
//		fprintf(stderr,"       ydiff = %d\n",ydiff);
		my_slope = (float)ydiff / (float)xdiff;
//		fprintf(stderr,"       slope = %f\n",my_slope);
	}
}

float Edge::slope(void) {
	return my_slope;
}

Vertex * Edge::one(void) {
	return vertex_one;
}

Vertex * Edge::two(void) {
	return vertex_two;
}
