#include "List.h"
#include "Vertex.h"
#include "Edge.h"

template<class T>
List<T>::List(Boolean nuke = TRUE) {
	stall_next = FALSE;
	destroy = nuke;
	head = tail = NULL;
	curr = prev = NULL;
}

template<class T>
List<T>::~List(void) {
	while (head) {
		tail = head;
		head = head->get_next();
		if (!destroy) tail->remove_data();
		delete tail;
	}
}

template<class T>
T * List<T>::start(void) {
	prev = NULL;
	curr = head;
	return (curr ? curr->read_data() : (T *)NULL);
}

template<class T>
T * List<T>::next(void) {
	if (!stall_next) {
		prev = curr;
		curr = (curr ? curr->get_next() : (Cell<T> *)NULL);
	}
	stall_next = FALSE;
	return (curr ? curr->read_data() : (T *)NULL);
}

template<class T>
void List<T>::remove(void) {
	if (head == curr) {
		if (tail == head) {
			head = tail = NULL;
		}
		else head = head->get_next();
		if (!destroy) curr->remove_data();
		delete curr;
		curr = prev = NULL;
		return;
	}
	// is it at the end?
	else if (tail == curr) {
		tail = prev;
	}
	// wasn't the head, so reset the previous
	prev->set_next(curr->get_next());
	if (!destroy) curr->remove_data();
	delete curr;
	curr=prev->get_next();
	stall_next = TRUE;
}

template<class T>
T * List<T>::find(T * what) {
	Cell<T> * curr;

	for (curr=head;curr;curr=curr->get_next()) {
		if (curr->read_data() == what) return what;
	}
	return NULL;
}	

template<class T>
Boolean List<T>::empty(void) {
	return int(!head);
}

template class List<char>;
template class List<Vertex>;
template class List<Edge>;
