#include "Queue.h"
#include "Vertex.h"
#include "Edge.h"

template<class T>
Queue<T>::Queue(int nuke=TRUE) : List<T>(nuke) {
	my_count = 0;
	return;
}

template<class T>
void Queue<T>::add(T * new_data) {
	Cell<T> * cell = new Cell<T>(new_data);

	if (!tail) {
		head = tail = cell;
	}
	else {
		tail->set_next(cell);
		tail = cell;
	}
	my_count ++;
}

template<class T>
void Queue<T>::push(T * new_data) {
	Cell<T> * cell = new Cell<T>(new_data);

	if (!head) {
		head = tail = cell;
	}
	else {
		cell->set_next(head);
		head = cell;
	}
}

template<class T>
T * Queue<T>::pop(void) {
	Cell<T> * hold;
	T * data;

	if (head) {
		hold = head;
		if (curr == head) curr=curr->get_next();
		head = head->get_next();
		data = hold->remove_data();
		delete hold;
	}
	else {
		data = NULL;
	}
	if (!head) tail=NULL;
	return data;
}

template class Queue<char>;
template class Queue<Vertex>;
template class Queue<Edge>;
