#ifndef _VERTEX_H_
#define _VERTEX_H_

#include "List.h"
#include "Queue.h"

typedef int Color;
#define NODE_WHITE 0
#define NODE_GREY  1
#define NODE_BLACK 2

class Vertex: public Coordinates {
private:
	Color my_color;
	Vertex * my_parent;
	Queue<Vertex> * my_adj;
	Queue<Vertex> * my_children;
public:
	Vertex(int new_x, int new_y): Coordinates(new_x,new_y) {
		my_color = NODE_WHITE;
		my_adj = new Queue<Vertex>(FALSE);
		my_children = new Queue<Vertex>(FALSE);
		my_parent = NULL;
	}
	~Vertex(void) {
		delete my_adj;
		delete my_children;
		if (my_parent) delete my_parent;
	}
	void set_color(Color which) {
		my_color = which;
	}
	Color color(void) {
		return my_color;
	}
	Queue<Vertex> * children(void) {
		return my_children;
	}
	Vertex * parent(void) {
		return my_parent;
	}
	Queue<Vertex> * adj(void) {
		return my_adj;
	}
};

#endif
