#include <X11/Ygl.h>
#include <stdlib.h>
#include <stdio.h>

#define XSIZE 320	/* default sizes */
#define YSIZE 200
#define STEP 5		/* Pixel Spacing */

#define DEBUG 1

#ifndef TRUE
# define TRUE  (0==0)
# define FALSE (!TRUE)
#endif

int ncolors;
Int32 win;
int winx=0,winy=0;

void MouseEvent(int x, int y) {
	x=y;
	return;
}

void drawit(Int32 w) {
  int i, j, col;

  winset(w);
  if(w == win) {
//    char *text = "This is font Times 14. Press ESC to exit...";
    color(WHITE); clear();
    col = 0;
    for(i=0; i<winx; i+=STEP) {
      color(col);
      for(j=0; j<winy; j+=STEP) pnt2s(i, j);
      
      /* Of course it's much faster to use this... */
//      rectfi(i,0,i+STEP-1,winy-1);
//      col = (col+1) % ncolors;
    }
//    color(WHITE); rectfi(5, 5, 10+strwidth(text), 30);
//    cmov2i(10, 10); color(BLACK); charstr(text);
  }
}

int main(int argc, char * argv[]) {
  char buf1[20],buf2[50];
  char * title = "Breadth First Search";
  int running = TRUE;
  Int32 x_offset=0,y_offset=0;
  int mouse_x=0,mouse_y=0;
  Device dev;
  short val;


  if (argc>1) winx = atoi(argv[1]);
  if (argc>1) winy = atoi(argv[2]);
  if (winx == 0) winx = XSIZE;
  if (winy == 0) winy = YSIZE;

  gversion(buf1);
  fprintf(stderr, "gversion '%s'\n",buf1);
  fprintf(stderr, "window size: %d x %d\n",winx,winy);
  fflush(stderr);

  minsize(winx,winy);
  win  = winopen(title);
  prefposition(0, 0, winx-1, winy-1);
//  winposition(0, 0, XSIZE-1, YSIZE-1);

  tie(LEFTMOUSE,MOUSEX,MOUSEY);  
//  qdevice(MOUSEX);
//  qdevice(MOUSEY);
  qdevice(LEFTMOUSE);
  qdevice(KEYBD);
  qdevice(WINQUIT);
  qdevice(REDRAW);

  winset(win);
  loadXfont(4711, "timr14");
  getfontencoding(buf2);
#ifdef DEBUG
  fprintf(stderr, "font = %d, encoding = '%s'\n", getfont(), buf2);
#endif
  font(4711);
  getfontencoding(buf2);
#ifdef DEBUG
  fprintf(stderr, "font = %d, encoding = '%s'\n", getfont(), buf2);
#endif
  
  ncolors = 1 << getplanes(); /* Number of colors */
  ncolors = (ncolors<8) ? ncolors : 8;    /* Number of predefined colors */

  while (running) {

    fprintf(stderr,"waiting for event...\n");
    dev = qread(&val);
#ifdef DEBUG
    fprintf(stderr, "dev = %d, *val = %d\n", dev, val);
#endif
    switch(dev) {
    case LEFTMOUSE:
      fprintf(stderr,"leftmouse\n");
      getorigin(&x_offset,&y_offset);
      fprintf(stderr,"%d %d\n",x_offset,y_offset);
      break;
    case MOUSEX:
      mouse_x = val - x_offset;
      fprintf(stderr,"mousex: %d\n",mouse_x);
      break;
    case MOUSEY:
      mouse_y = val - y_offset;
      fprintf(stderr,"mousey: %d\n",mouse_y);
      MouseEvent(mouse_x,mouse_y);
      break;
    case REDRAW:
      fprintf(stderr,"redraw\n");
      winset(val);
      reshapeviewport();
      drawit(val);
      break;
    case KEYBD:
      fprintf(stderr,"keybd\n");
      switch(val) {
      case 'p':
	printf("Piping main window through 'ppmtogif > Window1.gif'\n");
	winset( win); gl2ppm("| ppmtogif > Window1.gif");
	ringbell();
	break;
      case 'q':
      case '\033':
	running = FALSE;
	break;
      }
      break;
    case WINQUIT:
      fprintf(stderr,"winquit\n");
      running = FALSE;
      break;
    }
  }
  gexit();
  return(0);
}
