#include "../Ygl/X11/Ygl.h"
#include <time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "Queue.h"
#include "Vertex.h"
#include "Edge.h" 
#include "CoordHash.h"

#define MIN_SLOPE 15
#define DIVISOR	900	/* 25 is closest to planar */
#define STEP 50	/* Clump Spacing */

#define PROB 38 	/* 3/8 is closest to planar */
//#define PROB 100
#define XSIZE 320	/* default sizes */
#define YSIZE 200
//#define XSIZE 800	/* default sizes */
//#define YSIZE 600

int ncolors;
Int32 win;
int winx=0,winy=0;
CoordHash * table;
Queue<Vertex> * vlist = new Queue<Vertex>;
Queue<Edge> * elist = new Queue<Edge>;

#ifdef _NO_RINT_
float rint(float bob) {
	int dec;
	float extra;

	dec = (int)bob;
	extra = bob - (float)dec;
	if (extra > .5) {
		dec++;	
	}
	return (float)dec;
}
#endif

void redraw(void) {
  Vertex * vert;
  Edge * edge;
  Int32 verta[2];

  winset(win);
  reshapeviewport();
    color(BLACK);
    clear();
    for (edge = elist->start(); edge; edge = elist->next() ) {
	color(edge->color());
        bgnline();
	verta[0] = edge->one()->x();
        verta[1] = edge->one()->y();
	v2i(verta);
	verta[0] = edge->two()->x();
        verta[1] = edge->two()->y();
	v2i(verta);
	endline();
    }
    color(WHITE);
    for (vert = vlist->start(); vert; vert = vlist->next() ) {
	pnt2s(vert->x(), vert->y());
    }
/*
	int startx,endx,starty,endy,xx,yy,col;
	Queue<Vertex> * clumpy;
	Vertex * vertt;

	col = TRUE;
	color(col);
	table->getlimits(&startx,&starty,&endx,&endy);
	for (xx = startx; xx < endx; xx++) {
		col = !col;
		color(col);
		for (yy = starty; yy < endy; yy++) {
			col = !col;
			color(col);
			clumpy = table->chunk(xx,yy);
			for (vertt = clumpy->start();
				vertt; vertt = clumpy->next() ) {
					pnt2s(vertt->x(), vertt->y());
			}
		}
	}

*/
    sleep(0);
}

Vertex * closest(int x, int y) {
//	Queue<Vertex> * list;
	Vertex * vert;
	Vertex * best=NULL;
	int diff=STEP+STEP;
	int temp;

//	list = table->at(x,y);
	for (vert = vlist->start(); vert; vert = vlist->next() ) {
		temp = (abs(vert->x()-x) + abs(vert->y()-y));
		if (temp<diff) {
			best = vert;
			diff = temp;
		}
	}
	return best;
}

void MouseEvent(int x, int y) {
	Vertex * point = closest(x,y);
	Edge * edge;

	fprintf(stderr,"MouseEvent at (%d,%d)\n",x,y);

	if (point) {
		fprintf(stderr," closest vertex: (%d,%d)\n",point->x(),point->y());
		for (edge = elist->start(); edge; edge = elist->next()) {
			if (point == edge->one() || point == edge->two()) {
				if (edge->color()==RED) edge->set_color(BLUE);
				else edge->set_color(RED);
			}
		}
	}
	redraw();
	return;
}

Edge * EveryEdgeOk(Vertex * a, Vertex * b) {
	Edge * edge;
	Edge * nedge = new Edge(a,b,RED);
	Vertex * c, * d;
	int xa,xb,xc,xd,ya,yb,yc;
	float scd,sab,diff,xe;

	if (nedge->slope() >= MIN_SLOPE || nedge->slope() <= -MIN_SLOPE) {
		delete nedge;
		return NULL;
	}

//	fprintf(stderr,"is an edge between (%d,%d),(%d,%d) ok?\n",a->x(),a->y(),b->x(),b->y());

	for (edge=elist->start(); edge; edge = elist->next()) {
/*		fprintf(stderr,"  would it cut edge between (%d,%d),(%d,%d)?\n",
			edge->one()->x(),edge->one()->y(),edge->two()->x(),
			edge->two()->y());*/

		scd = edge->slope();
		sab = nedge->slope();
//		fprintf(stderr,"  old edge slope: %f, new edge slope: %f\n",scd,sab);

		diff = (sab - scd);
//		fprintf(stderr,"  diff: %f\n",diff);
	    if (diff!=0) {
		c = edge->one();
		d = edge->two();
		xd = d->x();
		xc = c->x();
		xb = b->x();
		xa = a->x();
		yc = c->y();
		yb = b->y();
		ya = a->y();
		xe = ((sab*xa - scd*xc + yc - ya)/(diff));
//		fprintf(stderr,"  intersection would be at: %f  - between %d and %d?\n",xe,xa,xb);
		if (xe<winx+1 && xe>-1) {
			int xe_int = (int)rint(xe);

//			fprintf(stderr,"  intersection would be at: %d  - between %d and %d?\n",xe_int,xa,xb);
			if (ZINXY(xa,xb,xe_int) && ZINXY(xc,xd,xe_int)) {
				delete nedge;
				return NULL;
			}
/*
			if ((xa > xb && xe_int < xa && xe_int > xb) ||
			   (xa <= xb && xe_int < xb && xe_int > xa)) {
				ye = (  (sab*scd*(xa-xc) - (scd*ya) + (sab*yc)) / diff );
				fprintf(stderr,"  intersection would be at: %f  - between %d and %d?\n",ye,ya,yb);
				if (ye<winy+1 && ye>-1) {
					int ye_int = (int)rint(ye);

					fprintf(stderr,"  intersection would be at: %d  - between %d and %d?\n",ye_int,ya,yb);
					if (ya > yb) {
						if (ye_int < ya && ye_int > yb) return NULL;
					}
					else {
						if (ye_int < yb && ye_int > ya) return NULL;
					}
				}
			}
		   */
		}
	  }
	}
//	fprintf(stderr," OKAY edge!\n");
	return nedge;
}

void generate_edges(Queue<Vertex> * vlist,int probability) {
  Vertex * vert;
  int vy,vx,total,far;
  Vertex * to_vert;
  Edge * okedge=NULL;
  int midy,midx,lowx,lowy,hix,hiy,winx_off,winy_off;
  Queue<Vertex> * clump;

  winx_off = table->offset(winx)+1;
  winy_off = table->offset(winy)+1;
  far = -1;
  total = vlist->count();
  for (vert = vlist->start(); vert; vert = vlist->next()) {
    far ++;
    fprintf(stderr,"%d/%d   \r",far,total);
    midy = table->offset(vert->y());
    midx = table->offset(vert->x());

    lowy=UMAX(0,midy-1);
    hiy=UMIN(winy_off,midy+2);
    lowx = UMAX(0,midx-1);
    hix = UMIN(winx_off,midx+2);
    for (vy=lowy;vy<hiy;vy++)  {
	for (vx = lowx;vx<hix;vx++) {
//	   fprintf(stderr,"clump (%d,%d)\n",vx,vy);
	   clump = table->chunk(vx,vy);
	   for (to_vert = clump->start(); to_vert; to_vert = clump->next()) {
	    if ( (to_vert!=vert) && 
		(!(vert->adj()->find(to_vert))) &&
		(( rand() % 100 ) < probability ) &&
		(okedge = EveryEdgeOk(to_vert,vert))!=NULL) {
		  elist->add(okedge);
		  vert->adj()->add(to_vert);
		  to_vert->adj()->add(vert);
	    }
	   }
	}
    }
  }
  
  Queue<Vertex> * leftover = new Queue<Vertex>(FALSE);
  for (vert = vlist->start(); vert; vert = vlist->next()) {
	if (!vert->adj()->start()) leftover->add(vert);
  }
  if (probability < 100) generate_edges(leftover,100);
  delete leftover;
}


int main(int argc, char * argv[]) {
	char buf1[20],buf2[50];
	int running = TRUE;
	Int32 x_offset=0,y_offset=0;
	int mouse_x=0,mouse_y=0;
	int i,max;
	Vertex * vert;

  srand(time(NULL));

#ifdef AIX
  putenv("YGL_FLUSHTIME=0");
#else
  setenv("YGL_FLUSHTIME","0",1);
#endif

  gversion(buf1);
  fprintf(stderr, "using gversion '%s'\n",buf1);

  if (argc>1) winx = atoi(argv[1]);
  if (argc>1) winy = atoi(argv[2]);
  if (winx == 0) winx = XSIZE;
  if (winy == 0) winy = YSIZE;
  fprintf(stderr, "grid size: %d x %d\n",winx,winy);

  fprintf(stderr, "generating vertexes...\n");
  table = new CoordHash(winx,winy,STEP);
  max = winx*winy/DIVISOR;
  for (i=0;i<max;i++) {
                vert = new Vertex(rand() % winx, rand() % winy);
                vlist->add(vert);
                table->add(vert);
  }
/*
  vert = new Vertex(80,80);
  vlist->add(vert);
  table->add(vert);
  vert = new Vertex(78,180);
  vlist->add(vert);
  table->add(vert);
  vert = new Vertex(180,120);
  vlist->add(vert);
  table->add(vert);
  vert = new Vertex(10,120);
  vlist->add(vert);
  table->add(vert);
  vert = new Vertex(1,1);
  vlist->add(vert);
  table->add(vert);
*/
  fprintf(stderr,"generating edges...\n");
  generate_edges(vlist,PROB);

  fprintf(stderr,"initializing window...\n");
  minsize(winx,winy);
  win = winopen("Breadth First Search");
  prefposition(0, 0, winx-1, winy-1);

  tie(LEFTMOUSE,MOUSEX,MOUSEY);
  qdevice(LEFTMOUSE);
  qdevice(RIGHTMOUSE);
  qdevice(KEYBD);
  qdevice(WINQUIT);
  qdevice(REDRAW);

  ncolors = 1 << getplanes(); /* Number of colors */
  ncolors = (ncolors<8) ? ncolors : 8;    /* Number of predefined colors */
  loadXfont(4711, "fixed");
  getfontencoding(buf2);
  font(4711);
  getfontencoding(buf2);

  fprintf(stderr,"running...\n");
  while (running) {
	Device dev;
	short val;
	int good_mouse;

    dev = qread(&val);
//    fprintf(stderr, "event on %d: %d\n", dev, val);
    switch(dev) {
    case LEFTMOUSE:
      good_mouse = (val==1);
      getorigin(&x_offset,&y_offset);
      dev = qread(&val);
      mouse_x = val - x_offset;
      dev = qread(&val);
      mouse_y = val - y_offset;
      if (good_mouse) MouseEvent(mouse_x,mouse_y);
      break;
    case REDRAW:
      fprintf(stderr,"redraw\n");
      redraw();
      break;
    case KEYBD:
      fprintf(stderr,"keybd\n");
      switch(val) {
      case 'p':
	printf("Piping main window through 'ppmtogif > Window1.gif'\n");
	winset( win); gl2ppm("| ppmtogif > Window1.gif");
	ringbell();
	break;
      case 'q':
      case '\033':
	running = FALSE;
	break;
      }
      break;
    case WINQUIT: case RIGHTMOUSE:
      fprintf(stderr,"winquit\n");
      running = FALSE;
      break;
    }
  }
  delete table;
  delete vlist;
  gexit();
  return(0);
}


/*
for (i=0;i<24;i++) {
	Vertex * curr;
	List<Vertex> * curr_list;
	char toprint = '-';
	printf("%d: ",i);
	for (int j=0;j<24;j++) {
		curr_list = table->by_offset(i)->by_offset(j);
		printf("[");
		for (curr = curr_list->start(); curr;printf("%c",toprint),curr = curr_list->next(),toprint = ' ') {
			toprint = '*';
		}
		printf("]");
	}
	printf("\n");
}
*/

